#include "ARPHeader.h"
#include "ETHHeader.h"
#include <iomanip>

ARPHeader::ARPHeader(u_short _opcode, u_char *_srcMAC, u_char *_dstMAC, u_char *_srcIP, u_char *_dstIP) 
{
  memset(&data, 0, ARP_HEADER_SIZE);
  data.hw_type = ARPHRD_ETHER;
  data.prot_type = ETH_FRAME_IP;
  data.hw_addr_size = ETH_ALEN;
  data.prot_addr_size = IP_ALEN;
  data.op = _opcode;
  memcpy(data.Dst_a_hw, _dstMAC, ETH_ALEN);
  memcpy(data.Src_a_hw, _srcMAC, ETH_ALEN);
  memcpy(data.Dst_a_ip, _dstIP, IP_ALEN);
  memcpy(data.Src_a_ip, _srcIP, IP_ALEN);            
}

ARPHeader::ARPHeader(const u_char *_data)
{	
  memcpy(&data, _data, sizeof(data));
  data2host();
}

void ARPHeader::dump()
{
  cout << "ARP Header:" << endl;
  cout << "  HW Type: 0x" << setbase(16) << setfill('0') << setw(2) << (int) data.hw_type << endl;
  cout << "  Protocol Type: 0x" << setw(2) << (int) data.prot_type << setbase(10) << setfill(' ') << endl;
  cout << "  HW Adr Size: " << (int)data.hw_addr_size << endl;
  cout << "  Prot Adr Size: " << (int) data.prot_addr_size << endl;
  cout << "  Opcode: 0x" << setbase(16) << setfill('0') << setw(2) << (int) data.op << setbase(10) << setfill(' ') << endl;
  cout << "  Source MAC: ";
  printMACAddress(data.Src_a_hw);
  cout << endl << "  Source IP: ";
  printIPAddress(data.Src_a_ip);
  cout << endl << "  Dest MAC: ";
  printMACAddress(data.Dst_a_hw);
  cout << endl << "  Dest IP: ";
  printIPAddress(data.Dst_a_ip);
  cout << endl << endl << endl;
}

void ARPHeader::setMem(u_char *_data)
{
  data2network();
  memcpy(_data, &data, sizeof(data));
  data2host();
}

const u_char *ARPHeader::srcMAC() const { 
  return data.Src_a_hw; 
}
const u_char *ARPHeader::dstMAC() const { 
  return data.Dst_a_hw; 
}

const u_char *ARPHeader::srcIP() const { 
  return data.Src_a_ip; 
}

const u_char *ARPHeader::dstIP() const { 
  return data.Dst_a_ip; 
}

u_short ARPHeader::opcode() const { 
  return data.op; 
}

void ARPHeader::data2host(void) {
  data.hw_type = ntohs(data.hw_type);
  data.prot_type = ntohs(data.prot_type);
  data.op = ntohs(data.op);
}

void ARPHeader::data2network(void) {
  data.hw_type = htons(data.hw_type);
  data.prot_type = htons(data.prot_type);
  data.op = htons(data.op);
}
